%% Crowdsourced cycling videos
% Matlab script built by Joost de Winter and Pavlo Bazilinskyy <p.bazilinskyy@tudelft.nl>
clear all;close all;clc; %#ok<*CLALL>

%% Consts
SAVE_DATA = false;  % true=process and save, false=load
FILE_DATA = 'data.mat';
xvalues = {'1.5 s','1.3 s','1.1 s','0.9 s','0.7 s'};  % values of TTC for output
yvalues = {'Automated GO','Automated','Traditional'};
% prefix for stimuli
prefix_stimuli_e2 = 'img/stimuli/image_';
% worker_code pattern
code_pattern_e2 = 'Q9\d+\s?RS\d+\s?4N';
% total number of stimuli
num_stimuli_e2 = 40;
% number of stimuli saved per block
num_stimuli_block_e2 = 1;
%% Read mapping data
[~,~,mapping] = xlsread('mapping_e1.xlsx','A2:I181');
[~,~,mapping_e2] = xlsread('mapping_e2.xlsx','B3:J42');
mapping=cell2mat(mapping(:,4:end));
mapping_e2=cell2mat(mapping_e2(:,4:end));
%%
if SAVE_DATA == true
    %% Load data
    % E1
    raw_heroku = readtable('data_e1.xlsx','ReadVariableNames',0); %%#ok<NASGU> % Import Excel file with Keypress data
    raw_appen = readtable('survey_data_e1.csv', 'ReadVariableNames', false);
    raw_appen = table2cell(raw_appen);  % convert to cell array for ease of checking
    % E2
    [~,~,raw_heroku_e2] = xlsread('data_e2.xlsx'); %%#ok<NASGU> % Import Excel file with Keypress data
    raw_appen_e2 = readtable('survey_data_e2.csv', 'ReadVariableNames', false);
    raw_appen_e2 = table2cell(raw_appen_e2);  % convert to cell array for ease of checking
    %% Filter appen data
    % E1
    X=NaN(size(raw_appen,1),290);
    disp(['E1. Number of respondents = ' num2str(size(raw_appen, 1))])
    temp=raw_appen(:,15);X(:,1)=strcmp(temp,'no')+2*strcmp(temp,'yes'); % Instructions understood
    temp=raw_appen(:,32);X(:,2)=1*strcmp(temp,'female')+2*strcmp(temp,'male')-1*strcmp(temp,'i_prefer_not_to_respond'); % Gender
    temp=raw_appen(:,31);for i=1:length(temp);try if strcmp(temp(i),'?');X(i,3)=NaN;else;X(i,3)= cell2mat(temp(i));end;catch error;X(i,3)=NaN;end;end % Age
    X(X(:,3)>110,3)=NaN; % People who report age greater than 110 years
    temp=raw_appen(:,14);for i=1:length(temp);try if strcmp(temp(i),'?');X(i,4)=NaN;else;X(i,4)= cell2mat(temp(i));end;catch error;X(i,4)=NaN;end;end % Age of obtaining driver's license
    X(X(:,4)>110,4)=NaN; % People who report licence more than 110 years
    temp=raw_appen(:,33);X(:,5)=1*strcmp(temp,'private_vehicle')+2*strcmp(temp,'public_transportation')+3*strcmp(temp,'motorcycle')+4*strcmp(temp,'walkingcycling')+5*strcmp(temp,'other')-1*strcmp(temp,'i_prefer_not_to_respond');  % Primary mode of transportation
    temp=raw_appen(:,28);X(:,6)=1*strcmp(temp,'never')+2*strcmp(temp,'less_than_once_a_month')+3*strcmp(temp,'once_a_month_to_once_a_week')+4*strcmp(temp,'1_to_3_days_a_week')+5*strcmp(temp,'4_to_6_days_a_week')+6*strcmp(temp,'every_day')-1*strcmp(temp,'i_prefer_not_to_respond'); % How many times in past 12 months did you drive a vehicle
    temp=raw_appen(:,13);for i=1:length(temp);try X(i,7)=1+cell2mat(temp(i));catch error;X(i,7)=1*strcmp(temp(i),'0_km__mi')+2*strcmp(temp(i),'1__1000_km_1__621_mi')+3*strcmp(temp(i),'1001__5000_km_622__3107_mi')+4*strcmp(temp(i),'5001__15000_km_3108__9321_mi')+5*strcmp(temp(i),'15001__20000_km_9322__12427_mi')+6*strcmp(temp(i),'20001__25000_km_12428__15534_mi')+7*strcmp(temp(i),'25001__35000_km_15535__21748_mi')+8*strcmp(temp(i),'35001__50000_km_21749__31069_mi')+9*strcmp(temp(i),'50001__100000_km_31070__62137_mi')+10*strcmp(temp(i),'more_than_100000_km_more_than_62137_mi')-1*strcmp(temp(i),'i_prefer_not_to_respond');end;end % Mileage
    temp=raw_appen(:,16);for i=1:length(temp);try X(i,8)=1+cell2mat(temp(i));catch error;X(i,8)=7*strcmp(temp(i),'more_than_5')-1*strcmp(temp(i),'i_prefer_not_to_respond');end;end % Number of accidents
    temp=raw_appen(:,9);Country=cell(size(X,1),1);for i=1:length(temp);try Country(i)=unique(temp(i));catch error;Country(i)={'NaN'};end;end % Country
    % Driver behaviour questionnaire (DBQ)
    temp=raw_appen(:,17:23);X(:,9:15)=1*strcmp(temp,'0_times_per_month')+2*strcmp(temp,'1_to_3_times_per_month')+3*strcmp(temp,'4_to_6_times_per_month')+4*strcmp(temp,'7_to_9_times_per_month')+5*strcmp(temp,'10_or_more_times_per_month')-1*strcmp(temp,'i_prefer_not_to_respond'); % DBQ violations
    X(X<0)=NaN;
    % worker ID
    temp=raw_appen(:,8);for i=1:length(temp);try if strcmp(temp(i),'?');X(i,290)=NaN;else;X(i,290)= cell2mat(temp(i));end;catch error;X(i,290)=NaN;end;end
    % E2
    X_e2=NaN(size(raw_appen_e2,1),331);
    disp(['E2. Number of respondents = ' num2str(size(raw_appen_e2, 1))])
    temp=raw_appen_e2(:,15);X_e2(:,1)=strcmp(temp,'no')+2*strcmp(temp,'yes'); % Instructions understood
    temp=raw_appen_e2(:,32);X_e2(:,2)=1*strcmp(temp,'female')+2*strcmp(temp,'male')-1*strcmp(temp,'i_prefer_not_to_respond'); % Gender
    temp=raw_appen_e2(:,31);for i=1:length(temp);try if strcmp(temp(i),'?');X_e2(i,3)=NaN;else;X_e2(i,3)= cell2mat(temp(i));end;catch error;X_e2(i,3)=NaN;end;end % Age
    X_e2(X_e2(:,3)>110,3)=NaN; % People who report age greater than 110 years
    temp=raw_appen_e2(:,14);for i=1:length(temp);try if strcmp(temp(i),'?');X_e2(i,4)=NaN;else;X_e2(i,4)= cell2mat(temp(i));end;catch error;X_e2(i,4)=NaN;end;end % Age of obtaining driver's license
    X_e2(X_e2(:,4)>110,4)=NaN; % People who report licence more than 110 years
    temp=raw_appen_e2(:,33);X_e2(:,5)=1*strcmp(temp,'private_vehicle')+2*strcmp(temp,'public_transportation')+3*strcmp(temp,'motorcycle')+4*strcmp(temp,'walkingcycling')+5*strcmp(temp,'other')-1*strcmp(temp,'i_prefer_not_to_respond');  % Primary mode of transportation
    temp=raw_appen_e2(:,28);X_e2(:,6)=1*strcmp(temp,'never')+2*strcmp(temp,'less_than_once_a_month')+3*strcmp(temp,'once_a_month_to_once_a_week')+4*strcmp(temp,'1_to_3_days_a_week')+5*strcmp(temp,'4_to_6_days_a_week')+6*strcmp(temp,'every_day')-1*strcmp(temp,'i_prefer_not_to_respond'); % How many times in past 12 months did you drive a vehicle
    temp=raw_appen_e2(:,13);for i=1:length(temp);try X_e2(i,7)=1+cell2mat(temp(i));catch error;X_e2(i,7)=1*strcmp(temp(i),'0_km__mi')+2*strcmp(temp(i),'1__1000_km_1__621_mi')+3*strcmp(temp(i),'1001__5000_km_622__3107_mi')+4*strcmp(temp(i),'5001__15000_km_3108__9321_mi')+5*strcmp(temp(i),'15001__20000_km_9322__12427_mi')+6*strcmp(temp(i),'20001__25000_km_12428__15534_mi')+7*strcmp(temp(i),'25001__35000_km_15535__21748_mi')+8*strcmp(temp(i),'35001__50000_km_21749__31069_mi')+9*strcmp(temp(i),'50001__100000_km_31070__62137_mi')+10*strcmp(temp(i),'more_than_100000_km_more_than_62137_mi')-1*strcmp(temp(i),'i_prefer_not_to_respond');end;end % Mileage
    temp=raw_appen_e2(:,16);for i=1:length(temp);try X_e2(i,8)=1+cell2mat(temp(i));catch error;X_e2(i,8)=7*strcmp(temp(i),'more_than_5')-1*strcmp(temp(i),'i_prefer_not_to_respond');end;end % Number of accidents
    temp=raw_appen_e2(:,9);Country_e2=cell(size(X_e2,1),1);for i=1:length(temp);try Country_e2(i)=unique(temp(i));catch error;Country_e2(i)={'NaN'};end;end % Country
    % Driver behaviour questionnaire (DBQ)
    temp=raw_appen_e2(:,17:23);X_e2(:,9:15)=1*strcmp(temp,'0_times_per_month')+2*strcmp(temp,'1_to_3_times_per_month')+3*strcmp(temp,'4_to_6_times_per_month')+4*strcmp(temp,'7_to_9_times_per_month')+5*strcmp(temp,'10_or_more_times_per_month')-1*strcmp(temp,'i_prefer_not_to_respond'); % DBQ violations
    X_e2(X_e2<0)=NaN;
    % worker ID
    temp=raw_appen_e2(:,8);for i=1:length(temp);try if strcmp(temp(i),'?');X_e2(i,331)=NaN;else;X_e2(i,331)= cell2mat(temp(i));end;catch error;X_e2(i,331)=NaN;end;end
    %% Expand X matrix to store values, last column is a flag if key press data for the row was found
    % E1
    X = [X zeros(size(X,1), 90) zeros(size(X,1), 90) zeros(size(X,1), 90) zeros(size(X,1), 1)];
    codes_matched = 0;  % counter for matched worker codes
    row_appen_matched = 0;  % row of appen data with matched code
    for i1=1:size(raw_heroku,1) % loop over rows
        extracted_row=table2array(raw_heroku(i1,1:end));
        counter_page = 0;  % counter of processed pages in heroku
        counter_rt = 0;  % counter of processed reaction time values
        recorded_rt = 0;  % number of recorded reaction time values
        code_matched = false;  % worker code matched
        image_id = 1;  % counter of detected image IDs
        % convert row of data in cells
        cell_in_row=cell2mat(extracted_row(2));
        % extract heroku code
        heroku_code = cell_in_row(regexp(cell_in_row,'worker_code')+14:end-1);
        % match worker codes
        row_appen_matched=find(strcmp(heroku_code,raw_appen(:,30)));
        for i2=1:length(extracted_row)  % loop over the row
            cell_in_row=cell2mat(extracted_row(i2));  % extract cells from row
            if cell_in_row(regexp(cell_in_row,'image_')) % extract image id
                imageid(i1, image_id)=str2double(cell_in_row(regexp(cell_in_row,'image_')+6:end-5));
                image_id = image_id + 1;
            end
            if regexp(cell_in_row,'rt:') % keypress time found
                counter_page = counter_page + 1;
                % skip instruction screen RTs
                if counter_page ~= 1 && counter_page ~= 2 && counter_page ~= 3  && counter_page ~= 34 && counter_page ~= 35 && counter_page ~= 36 && counter_page ~= 67 && counter_page ~= 68 && counter_page ~= 69
                    rt = str2double(cell_in_row(regexp(cell_in_row,'rt:')+3:end-2));
                    if isnan(rt)
                        % Record time key press from temp array into key presses
                        rt = str2double(cell_in_row(regexp(cell_in_row,'rt:')+3:end-1));
                    end
                    recorded_rt = recorded_rt + 1;
                    RT(i1,recorded_rt) = rt;
                end
            end
            if regexp(cell_in_row,'key_press:') % keypress time found
                key_pressed = str2double(cell_in_row(regexp(cell_in_row,'key_press:')+10:end));
                if key_pressed == 66 || key_pressed == 80 % skip 'C'  66 = B, 80 = P
                    counter_rt = counter_rt + 1;
                    % record time key press from temp array into key presses
                    RP(i1, counter_rt) = key_pressed;
                end
            end
        end
        % if code not matched, continue
        if ~isempty(row_appen_matched)
            row_appen_matched=row_appen_matched(1);
            % record reaction times
            X(row_appen_matched, 19:108)=RT(i1,:);
            % record pressed keys
            X(row_appen_matched, 109:198)=RP(i1,:);
            % record stimuli shown
            X(row_appen_matched, 199:288)=imageid(i1,:);
            % set a flag that row was matched
            X(row_appen_matched, 289)=1;
            % increment number of codes matched
            codes_matched = codes_matched + 1;
        end
    end
    % todo: check why X receiving extra columns 291+
    X(:, 291:end)=[];  % trim X
    disp(['Codes matched ' num2str(codes_matched)]);
    %% E2
    %%% Process keypress data
    % reaction time values for participants
    RT_e2 = NaN(size(raw_appen_e2,1), num_stimuli_e2);
    % pressed keys for participants
    RP_e2 = NaN(size(raw_appen_e2,1), num_stimuli_e2);
    % stimulus questions
    Stimulus_qs_e2 = NaN(size(raw_appen_e2,1), num_stimuli_e2, 4);
    % end questions
    End_qs_e2 = NaN(size(raw_appen_e2,1), 10, 3);
    % open text responses for q2 in the end
    End_q2_e2 = strings(size(raw_appen_e2,1), 10, 1);
    % IDs of stimuli shown
    imageid_e2 = NaN(size(raw_appen_e2,1), num_stimuli_e2);
    % flags for blocks that were found. displaying the state of this matrix
    % in the end of the function can be used to debug if all data were parsed
    % successfully
    found_values = zeros(size(raw_appen_e2,1), num_stimuli_e2/num_stimuli_block_e2);
    % count people that added the same worker_code more than once
    counter_cheaters = 0;
    cheater_worker_codes=[];  % store worker_codes of cheaters
    cheater_worker_ids=[];
    cheater_worker_worker_codes=[];
    disp([datestr(now, 'HH:MM:SS.FFF') ' - E2. Start of processing heroku data']);
    for row_heroku=1:size(raw_heroku_e2,1) % loop over rows
        if (mod(row_heroku,100)==0)
            disp([datestr(now, 'HH:MM:SS.FFF') ' - Processing row ' ...
                num2str(row_heroku) ' in heroku data ']);
        end
        % store data from the current row to add to the correct place in X
        % RT values in the row. Allocate num_in_row for multiple RT values
        RT_row = 0;   % keypress values in row
        RP_row = 0;  % pressed keys in the row
        Stimulus_qs_row = zeros(num_stimuli_block_e2,4);  % stimulus questions values in the row
        End_qs_row = zeros(10,3);  % end questions values in the row
        End_q2_row = strings(10,1);
        stimulus_id_row = 0;  % stimulus ID value in row
        detected_browser = 0;  % detected browser
        extracted_row = raw_heroku_e2(row_heroku,:);  % row of data in heroku
        stimulus_detected = false;  % flag for starting to data for stimulus
        heroku_code = '';  % worker_code in heroku data
        % ID of zoomed_in image
        zoom_ids = zeros(10,1);
        % number of questions in the end in the row processed
        end_qs_processed = 0;
        % processding array with zoom image ids
        zoom_ids_detected = 0;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Go over rows of heroku data. Process possible values in the cell
        % one by one and parse values in different ways. We assume that 1
        % cell can contain only 1 type of data. If the study is set up to
        % allow parsing the same cell in multiple ways, 'continue'
        % statements should be removed.
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        for cell_row=1:length(extracted_row)
            % work with 1 particular cell from the row of data
            cell_row=cell2mat(extracted_row(cell_row));
            % skip NaN cell
            if(isnan(cell_row))
                continue;  % skip this cell
            end
            % skip empty cell
            if(size(cell_row,1) == 0)
                continue;  % skip this cell
            end
            % skip numeric cell
            if(isnumeric(cell_row))
                % add new zoom_id detected
                if zoom_ids_detected > 0
                    zoom_ids_detected = zoom_ids_detected + 1;
                    zoom_ids(zoom_ids_detected) = cell_row;
                end
                continue;  % skip this cell
            end
            % keypress time
            code_regex = regexp(cell_row, 'rt:','match');
            if size(code_regex,1) > 0 && stimulus_detected % keypress time found
                % Record time key press from row array into key presses
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                if (size(found_numbers,1)) > 1  % scientific notation
                    num = str2num(string(found_numbers(1)));
                    power_of = str2num(string(found_numbers(1)));
                    RT_row = num.^power_of;
                else  % normal float
                    RT_row = str2num(string(found_numbers(1)));
                end
                % end of data for stimulus
                stimulus_detected = false;
                continue;  % only 1 item can be picked up from the cell
            end
            % pressed key for stimulus
            if strcmp(cell_row, 'key_press:66') || strcmp(cell_row, 'key_press:80') % pressed key found
                % Record time key press from row array into key presses
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                RP_row = str2num(string(found_numbers(1))); %#ok<*ST2NM>
                % start of data fo stimulus
                stimulus_detected = true;
                continue;  % only 1 item can be picked up from the cell
            end
            % worker code
            code_regex = regexp(cell_row, code_pattern_e2,'match');
            if size(code_regex,1) > 0 % worker_code found
                heroku_code = code_regex(1);
                continue;  % only 1 item can be picked up from the cell
            end
            % stimulus ID
            if size(cell_row,2) >= 28
                if strcmp(cell_row(1:28),strcat('stimulus:"', prefix_stimuli_e2))
                    % stimulus ID found
                    found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                    if (size(found_numbers,1)) > 0  % found numbers
                        stimulus_id_row = str2num(string(found_numbers(1)));
                    end
                    continue;  % only 1 item can be picked up from the cell
                end
            end
            % stimulus q1
            code_regex = regexp(cell_row, '\\"sticker\\":','match');
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                Stimulus_qs_row(1) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            % stimulus q2
            code_regex = regexp(cell_row, '\\"windows\\":','match');
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                Stimulus_qs_row(2) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            % stimulus q3
            code_regex = regexp(cell_row, '\\"go\\":','match');
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                Stimulus_qs_row(3) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            % stimulus q4
            code_regex = regexp(cell_row, '\\"driver\\":','match');
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                Stimulus_qs_row(4) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            % ids of zoom-in images
            code_regex = regexp(cell_row, 'zoom_ids','match');
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                zoom_ids_detected = zoom_ids_detected + 1;
                zoom_ids(zoom_ids_detected) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            code_regex = regexp(cell_row, '\d+]','match');  % last ID
            if size(code_regex,1) > 0 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                zoom_ids_detected = zoom_ids_detected + 1;
                zoom_ids(zoom_ids_detected) = str2num(string(found_numbers(1)));
                continue;  % only 1 item can be picked up from the cell
            end
            % end q1
            code_regex = regexp(cell_row, '\\"q0\\":','match');
            if size(code_regex,1) > 0 && zoom_ids_detected == 10 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                end_qs_processed = end_qs_processed + 1;
                End_qs_row(zoom_ids(end_qs_processed), 1) = str2num(string(found_numbers(2)));
                continue;  % only 1 item can be picked up from the cell
            end
            % end q2 (text response)
            code_regex = regexp(cell_row, '\\"q1\\":','match');
            if size(code_regex,1) > 0 && zoom_ids_detected == 10 % responses to question found
                End_q2_row(zoom_ids(end_qs_processed)) = cell_row(10:end-2);
                continue;  % only 1 item can be picked up from the cell
            end
            % end q3
            code_regex = regexp(cell_row, '\\"q2\\":','match');
            if size(code_regex,1) > 0 && zoom_ids_detected == 10 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                End_qs_row(zoom_ids(end_qs_processed), 2) = str2num(string(found_numbers(2)));
                continue;  % only 1 item can be picked up from the cell
            end
            % end q4
            code_regex = regexp(cell_row, '\\"q3\\":','match');
            if size(code_regex,1) > 0 && zoom_ids_detected == 10 % responses to question found
                found_numbers = regexp(cell_row,'\d+\.?\d*','match');
                % assign 1st found number as value
                End_qs_row(zoom_ids(end_qs_processed), 3) = str2num(string(found_numbers(2)));
                continue;  % only 1 item can be picked up from the cell
            end
            % extract browser info as stored in the javascript
            % navigator.userAgent object. List of browsers is at:
            % https://developer.mozilla.org/en-US/docs/Web/HTTP/Browser_detection_using_the_user_agent
            if size(regexp(cell_row, '^.*Firefox.*$','match'),1) > 0
                detected_browser = 1;  % Firefox
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Seamonkey.*$','match'),1) > 0
                detected_browser = 2;  % Seamonkey
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Safari.*$','match'),1) > 0
                detected_browser = 3;  % Safari
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Chrome.*$','match'),1) > 0
                detected_browser = 4;  % Chrome
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Chromium.*$','match'),1) > 0
                detected_browser = 5;  % Chromium
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*OPR.*$','match'),1) > 0
                detected_browser = 6;  % Opera 15+ (Blink-based engine)
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Opera.*$','match'),1) > 0
                detected_browser = 6;  % Opera 12- (Presto-based engine)
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*MSIE.*$','match'),1) > 0
                detected_browser = 7;  % Internet Explorer 10-
                continue;  % only 1 item can be picked up from the cell
            elseif size(regexp(cell_row, '^.*Trident.*$','match'),1) > 0
                detected_browser = 7;  % Internet Explorer 11
                continue;  % only 1 item can be picked up from the cell
            end
        end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Add data to corresponding row in X
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % find occurances of the same worker_code in appen data
        row_appen_matched=find(strcmp(heroku_code, raw_appen_e2(:,30)));
        if ~isempty(row_appen_matched)
            % multiple instances of worker_code found
            if (size(row_appen_matched, 1) > 1)
                % found a cheater
                if ~any(strcmp(cheater_worker_codes, heroku_code))
                    % worker_code was not marked as cheater before
                    % add to the list of known cheaters.
                    % store worker ID as well
                    cheater_worker_codes = [cheater_worker_codes, ...
                        heroku_code];
                    cheater_worker_ids = [cheater_worker_ids; ...
                        raw_appen_e2(row_appen_matched, 8)];
                    cheater_worker_worker_codes = [cheater_worker_worker_codes; ...
                        raw_appen_e2(row_appen_matched, 30)];
                    % increase counter of cheaters
                    counter_cheaters = counter_cheaters + 1;
                end
            end
            % for storind data, use only 1st occurrence of worker_id in
            % appen data
            row_appen_matched=row_appen_matched(1);
            % stimulus detected
            if stimulus_id_row > 0
                % check values from which block to add 1st block
                if found_values(row_appen_matched,1) == 0
                    block_id = 1;
                    found_values(row_appen_matched, 1) = 1;
                    % detected browser
                    % if -1, default value was not changed hence no change in
                    % this row
                    if detected_browser ~= -1
                        % assign browser code
                        X_e2(row_appen_matched, 19) = detected_browser;
                    end
                    % flag that row was matched
                    X_e2(row_appen_matched, 20) = 1;
                    % not 1st block (2...n block)
                else
                    % find last processed block
                    last_block = find(found_values(row_appen_matched,:), ...
                        1, ...  % if 1, it was already processed
                        'last');  % get only last occurrence of 1
                    % new block is last block + 1
                    block_id = last_block + 1;
                    % check if block_id is within allowed range
                    if (block_id > num_stimuli_e2/num_stimuli_block_e2)
                        continue;
                    end
                    % update cell in matrix of processed blocks
                    found_values(row_appen_matched, block_id) = 1;
                end
                % add RT values
                RT_e2(row_appen_matched, block_id) = RT_row;
                % add pressed keys
                RP_e2(row_appen_matched, block_id) = RP_row;
                % add stimulus questions
                Stimulus_qs_e2(row_appen_matched, block_id, :) = Stimulus_qs_row;
                % add stimuli ids as shown
                imageid_e2(row_appen_matched, block_id) = stimulus_id_row;
            end
            % working with row with zoom-in images
            if zoom_ids_detected == 10
                % add end questions
                End_qs_e2(row_appen_matched, :, :) = End_qs_row;
                % add q2 from end questions
                for q2_ans=1:10
                    End_q2_e2(row_appen_matched, q2_ans) = End_q2_row(q2_ans);
                end
            end
        end
    end
    % add data to X_e2
    X_e2(:, 21:60)=RT_e2;
    X_e2(:, 61:100)=RP_e2;
    X_e2(:, 101:140)=imageid_e2;
    X_e2(:, 141:180)=Stimulus_qs_e2(:,:,1);
    X_e2(:, 181:220)=Stimulus_qs_e2(:,:,2);
    X_e2(:, 221:260)=Stimulus_qs_e2(:,:,3);
    X_e2(:, 261:300)=Stimulus_qs_e2(:,:,4);
    X_e2(:, 301:310)=End_qs_e2(:,:,1);
    X_e2(:, 311:320)=End_qs_e2(:,:,2);
    X_e2(:, 321:330)=End_qs_e2(:,:,3);
    % save list of cheaters to csv
    if size(cheater_worker_ids, 1) > 0
        disp([datestr(now, 'HH:MM:SS.FFF') ' - E2. Number of respondents who input the same code multiple times (cheaters) = ' num2str(counter_cheaters)]);
        cheaters = cell2table([cheater_worker_ids, cheater_worker_worker_codes], 'VariableNames', {'worker_id','worker_code'});
        writetable(cheaters, 'cheaters.csv');
    end
    disp([datestr(now, 'HH:MM:SS.FFF') ' - E2. End of processing heroku data']);
    %% Survey time (before filtering)
    for i=1:size(raw_appen, 1)
        % extract time of start of appen job by participant
        % Note: datenum is known to cause errors/warnings. It works as
        % expected in Matlab 2020a
        starttime=datenum(raw_appen{i,4});
        % extract time of end of appen job by participant
        endtime=datenum(raw_appen{i,2});
        % save info on time for participant to the matrix
        X(i,16)=starttime;
        X(i,17)=endtime;
        X(i,18)=round(2400*36*(endtime - starttime));
    end
    disp(['E1. Survey time mean (minutes) = ' num2str(nanmean(X(:,18)/60))]);
    disp(['E1. Survey time median (minutes) = ' num2str(nanmedian(X(:,18)/60))]);
    disp(['E1. Survey time SD (minutes) = ' num2str(nanstd(X(:,18)/60))]);
    disp(['E1. First survey start date = ' datestr(min(X(:,16)))]);
    disp(['E1. Last survey end date = ' datestr(max(X(:,17)))]);
    
    for i=1:size(raw_appen_e2, 1)
        % extract time of start of appen job by participant
        % Note: datenum is known to cause errors/warnings. It works as
        % expected in Matlab 2020a
        starttime=datenum(raw_appen_e2{i,4});
        % extract time of end of appen job by participant
        endtime=datenum(raw_appen_e2{i,2});
        % save info on time for participant to the matrix
        X_e2(i,16)=starttime;
        X_e2(i,17)=endtime;
        X_e2(i,18)=round(2400*36*(endtime - starttime));
    end
    disp(['E2. Survey time mean (minutes) = ' num2str(nanmean(X_e2(:,18)/60))]);
    disp(['E2. Survey time median (minutes) = ' num2str(nanmedian(X_e2(:,18)/60))]);
    disp(['E2. Survey time SD (minutes) = ' num2str(nanstd(X_e2(:,18)/60))]);
    disp(['E1. First survey start date = ' datestr(min(X_e2(:,16)))]);
    disp(['E2. Last survey end date = ' datestr(max(X_e2(:,17)))]);
    %% save data
%    save(FILE_DATA, 'X', 'Country', 'X_e2','Country_e2');
    save(FILE_DATA, 'X', 'Country', 'raw_appen', 'X_e2', 'Country_e2', 'raw_appen_e2');

    disp(['Data saved to ' FILE_DATA]);
else % load data
    load(FILE_DATA); % load data
    disp(['Data loaded from ' FILE_DATA]);
end
%% Remove participants who did not meet the criteria
%% E1
invalid1 = find(X(:,1)==1); % respondents who did not read instructions
invalid2 = find(X(:,3)<18);  % respondents who indicated they are under 18 years old
invalid3 = find(X(:,18)<300);  % respondents who took less than 5 min to complete
%% Find rows with identical IP addresses
y = NaN(size(X(:,1)));
IPCF=NaN(size(raw_appen,1),1);
for i=1:size(raw_appen,1)
    try IPCF(i)=str2double(strrep(raw_appen(i,12),'.',''));
    catch
        IPCF(i)=cell2mat(raw_appen(i,12));
    end
end % reduce IP addresses of appen to a single number
for i=1:size(X,1)
    temp=find(IPCF==IPCF(i));
    if length(temp)==1 % if the IP address occurs only once
        y(i)=1; % keep
    elseif length(temp)>1 % if the IP address occurs more than once
        y(temp(1))=1; % keep the first survey for that IP address
        y(temp(2:end))=2; % no not keep the other ones
    end
end
invalid4=find(y>1); % respondents who completed the survey more than once (i.e., remove the doublets)
%% Find rows with not matched responses
invalid5 = find(isnan(sum(X(:,19:289),2))); % respondents with no response data / match
%% filter out data
invalid = unique([invalid1;invalid2;invalid3;invalid4;invalid5]); % Add together all invalid rows with data
X(invalid,:)=[]; % Remove invalid respondents
Country(invalid)=[]; % Remove invalid countries
raw_appen(invalid,:)=[]; % Remove invalid respondents
IPCF(invalid,:)=[]; % Remove invalid respondents

%% E2
invalid1_e2 = find(X_e2(:,1)==1); % respondents who did not read instructions
invalid2_e2 = find(X_e2(:,3)<18);  % respondents who indicated they are under 18 years old
invalid3_e2 = find(X_e2(:,18)<300);  % respondents who took less than 5 min to complete
%% Find rows with identical IP addresses
y = NaN(size(X_e2(:,1)));
IPCF_e2=NaN(size(raw_appen_e2,1),1);
for i=1:size(raw_appen_e2,1)
    try IPCF_e2(i)=str2double(strrep(raw_appen_e2(i,12),'.',''));
    catch
        IPCF_e2(i)=cell2mat(raw_appen_e2(i,12));
    end
end % reduce IP addresses of appen to a single number
for i=1:size(X_e2,1)
    temp=find(IPCF_e2==IPCF_e2(i));
    if length(temp)==1 % if the IP address occurs only once
        y(i)=1; % keep
    elseif length(temp)>1 % if the IP address occurs more than once
        y(temp(1))=1; % keep the first survey for that IP address
        y(temp(2:end))=2; % no not keep the other ones
    end
end
invalid4_e2=find(y>1); % respondents who completed the survey more than once (i.e., remove the doublets)
%% Find rows with not matched responses
invalid5_e2 = find(isnan(sum(X_e2(:,[21 101:140]),2)));
%% filter out data
invalid_e2 = unique([invalid1_e2;invalid2_e2;invalid3_e2;invalid4_e2;invalid5_e2]); % Add together all invalid rows with data
X_e2(invalid_e2,:)=[]; % Remove invalid respondents
Country_e2(invalid_e2)=[]; % Remove invalid countries
raw_appen_e2(invalid_e2,:)=[]; % Remove invalid respondents
IPCF_e2(invalid_e2,:)=[]; % Remove invalid respondents
%% Output with statistics and filtering information
disp(['E1. Number of respondents who did not read instructions = ' num2str(length(invalid1))])
disp(['E1. Number of respondents under 18 = ' num2str(length(invalid2))])
disp(['E1. Number of respondents who took less than 300 s = ' num2str(length(invalid3))])
disp(['E1. Number of responses coming from the same IP = ' num2str(length(invalid4))])
disp(['E1. Number of rows in keypress data not matched = ' num2str(length(invalid5))]);
disp(['E1. Number of respondents removed = ' num2str(length(invalid))])
disp(['E1. Number of respondents included in the analysis:  ' num2str(size(X,1))]);
disp(['E1. Number of countries included in the analysis:  ' num2str(length(unique(Country)))]);
% disp(['Number of videos per person, min max, mean, sd : ' num2str((min(sum(~isnan(key_pressesf(:,:,110)),2)))) '   ' num2str((max(sum(~isnan(key_pressesf(:,:,110)),2)))) '   ' num2str((mean(sum(~isnan(key_pressesf(:,:,110)),2)))) '    ' num2str((std(sum(~isnan(key_pressesf(:,:,110)),2))))])
disp(['E2. Number of respondents who did not read instructions = ' num2str(length(invalid1_e2))])
disp(['E2. Number of respondents under 18 = ' num2str(length(invalid2_e2))])
disp(['E2. Number of respondents who took less than 300 s = ' num2str(length(invalid3_e2))])
disp(['E2. Number of responses coming from the same IP = ' num2str(length(invalid4_e2))])
disp(['E2. Number of rows in keypress data not matched = ' num2str(length(invalid5_e2))]);
disp(['E2. Number of respondents removed = ' num2str(length(invalid_e2))])
disp(['E2. Number of respondents included in the analysis:  ' num2str(size(X_e2,1))]);
disp(['E2. Number of countries included in the analysis:  ' num2str(length(unique(Country_e2)))]);
%% Gender, age, primary mode of transport
disp(['E1. Gender, male respondents = ' num2str(sum(X(:,2)==2))])
disp(['E1. Gender, female respondents = ' num2str(sum(X(:,2)==1))])
disp(['E1. Gender, I prefer not to respond = ' num2str(sum(isnan(X(:,2))))])
disp(['E1. Age, mean = ' num2str(nanmean(X(:,3)))])
disp(['E1. Age, sd = ' num2str(nanstd(X(:,3)))])
disp(['E1. Age, min = ' num2str(min(X(:,3)))])
disp(['E1. Age, max = ' num2str(max(X(:,3)))])
disp(['E1. Private vehicle, public transportation, motorcycle, walking/cycling, other = ' num2str(histc(X(:,5),1:5)')])
disp(['E2. Gender, male respondents = ' num2str(sum(X_e2(:,2)==2))])
disp(['E2. Gender, female respondents = ' num2str(sum(X_e2(:,2)==1))])
disp(['E2. Gender, I prefer not to respond = ' num2str(sum(isnan(X_e2(:,2))))])
disp(['E2. Age, mean = ' num2str(nanmean(X_e2(:,3)))])
disp(['E2. Age, sd = ' num2str(nanstd(X_e2(:,3)))]) %#ok<*NANSTD>
disp(['E2. Age, min = ' num2str(min(X_e2(:,3)))])
disp(['E2. Age, max = ' num2str(max(X_e2(:,3)))])
disp(['E2. Private vehicle, public transportation, motorcycle, walking/cycling, other = ' num2str(histc(X_e2(:,5),1:5)')])
%% Survey time (after filtering)
disp(['E1. Survey time mean (minutes) = ' num2str(nanmean(X(:,18)/60))]);
disp(['E1. Survey time median (minutes) = ' num2str(nanmedian(X(:,18)/60))]); %#ok<*NANMEDIAN>
disp(['E1. Survey time SD (minutes) = ' num2str(nanstd(X(:,18)/60))]);
disp(['E1. First survey start date = ' datestr(min(X(:,16)))]);
disp(['E1. Last survey end date = ' datestr(max(X(:,17)))]);
disp(['E2. Survey time mean (minutes) = ' num2str(nanmean(X_e2(:,18)/60))]);
disp(['E2. Survey time median (minutes) = ' num2str(nanmedian(X_e2(:,18)/60))]);
disp(['E2. Survey time SD (minutes) = ' num2str(nanstd(X_e2(:,18)/60))]);
disp(['E2. First survey start date = ' datestr(min(X_e2(:,16)))]);
disp(['E2. Last survey end date = ' datestr(max(X_e2(:,17)))]);

%% Most common countries (after filtering)
[~, ~, ub] = unique(Country);
test2counts = histcounts(ub, 'BinMethod','integers');
[B,I] = maxk(test2counts,5);
country_unique = unique(Country);
disp('E1. Most common countries (after filtering) = ')
disp(country_unique(I)')
disp(B)
[~, ~, ub_e2] = unique(Country_e2);
test2counts = histcounts(ub_e2, 'BinMethod','integers');
[B_e2,I_e2] = maxk(test2counts,5);
country_unique_e2 = unique(Country_e2);
disp('E2. Most common countries (after filtering) = ')
disp(country_unique_e2(I_e2)')
disp(B_e2)
%% Save data from X into variables for E1
% Save data from X into variables
RT = X(:, 19:108);
RP = X(:, 109:198);
% convert keypresses: to 1 (B) and 2 (P)   (66 = B, 80 = P)
RP = sign(RP-66) + 1;
imageid = X(:,199:288);
% Order data by stimulus ID
RPo=NaN(size(RP,1),180);
RTo=NaN(size(RT,1),180);
for i=1:size(RP,1) % loop over participants
    RPo(i,imageid(i,:))=RP(i,:);
    RTo(i,imageid(i,:))=RT(i,:);
end
%% Save data from X into variables for E2
% Save data from X into variables
RT_e2 = X_e2(:, 21:60);
RP_e2 = X_e2(:, 61:100);
% convert to 1 (B) and 2 (P)   (66 = B, 80 = P)
RP_e2=sign(RP_e2-66) + 1;
imageid_e2 = X_e2(:, 101:140);
% stimulus questions
Stimulus_qs_e2 = NaN(size(X_e2,1), num_stimuli_e2, 4);
Stimulus_qs_e2(:,:,1) = X_e2(:, 141:180);
Stimulus_qs_e2(:,:,2) = X_e2(:, 181:220);
Stimulus_qs_e2(:,:,3) = X_e2(:, 221:260);
Stimulus_qs_e2(:,:,4) = X_e2(:, 261:300);
% end questions
End_qs_e2 = NaN(size(X_e2,1), 10, 3);
End_qs_e2(:,:,1) = X_e2(:, 301:310);
End_qs_e2(:,:,2) = X_e2(:, 311:320);
End_qs_e2(:,:,3) = X_e2(:, 321:330);
% Order data by stimulus ID
RPo_e2=NaN(size(RP_e2,1),num_stimuli_e2);
RTo_e2=NaN(size(RT_e2,1),num_stimuli_e2);
Stimulus_qs_o_e2=NaN(size(Stimulus_qs_e2));
for i=1:size(RP_e2,1) % loop over pp
    RPo_e2(i,imageid_e2(i,:))=RP_e2(i,:);
    RTo_e2(i,imageid_e2(i,:))=RT_e2(i,:);
    Stimulus_qs_o_e2(i,imageid_e2(i,:),1) = 1-Stimulus_qs_e2(i,:, 1); % There was a sticker and sensor on the car.
    Stimulus_qs_o_e2(i,imageid_e2(i,:),2) = 1-Stimulus_qs_e2(i,:, 2); % The windows of the car were blinded.
    Stimulus_qs_o_e2(i,imageid_e2(i,:),3) = 1-Stimulus_qs_e2(i,:, 3); % There was a message 'GO' on the car.
    Stimulus_qs_o_e2(i,imageid_e2(i,:),4) = 1-Stimulus_qs_e2(i,:, 4); % A driver was visible in the car.
end
%% correct mapping error
% 97 is Driver. This was not shown initially.
% 99 is Blinded
pause_in_task=find(diff(X(:,16))>.1,1,'first'); % find last index with the incorrect mapping
temp=find(isnan(RPo(1:pause_in_task,99)) & ~isnan(RPo(1:pause_in_task,97))); % find indexes where 99 is NaN and 97 is not NaN
RPo(temp,99)=RPo(temp,97);  % transfer data from 97 to 99
RTo(temp,99)=RTo(temp,97);  % transfer data from 97 to 99
RPo(temp,97)=NaN;  % set 97 to NaN
RTo(temp,97)=NaN;  % set 97 to NaN
disp(['E1. Mapping corrected for = ' num2str(pause_in_task)]);
%% Proportion of people who braked
RPoP=100*(2-RPo); % proportion of people who braked
RPoP_e2=100*(2-RPo_e2); % proportion of people who braked
%% People that did both E1 and E2
[lo , ii] = ismember(X(:,290), X_e2(:,331));
X_e1_e2 = {X(lo,:), X_e2(ii(lo),:)};
%% Table 3. Regression model statistics for prediction of the braking percentage (n = 180). (Experiment 1)
y=nanmean(RPoP,1)';
x=[2-mapping(:,1) mapping(:,2:3)-1 mapping(:,4)==1 mapping(:,4)==2 mapping(:,5)==2 mapping(:,5)==3];
stu=regstats(y, x);
y=zscore(y);x=zscore(x);
st=regstats(y, x);
disp('Table 3')
disp([round([stu.beta st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
disp(['Number of trials in the regression analysis = ' num2str(length(y))])
disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
%% Table S1. Experiment 2: Regression model statistics for prediction of the braking percentage (n = 36 images without eye contact).
y= nanmean(RPoP_e2,1)';
x=[2-mapping_e2(:,1) mapping_e2(:,2)-1 mapping_e2(:,4)==1 mapping_e2(:,4)==2 mapping_e2(:,5)==2 mapping_e2(:,5)==3]; % same as Experiment 1, except Background (which was constant in Experiment 2)
x([7 17 28 37],:)=[];y([7 17 28 37])=[]; % remove the eye-contact
stu=regstats(y, x);
y=zscore(y);x=zscore(x);
st=regstats(y, x);
disp('Table S1')
disp([round([stu.beta st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
disp(['Number of trials in the regression analysis = ' num2str(length(y))])
disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
%% Table 4. Regression model statistics for prediction of the median response time in milliseconds (n = 180). (Experiment 1)
y=nanmedian(RTo,1)';
x=[2-mapping(:,1) mapping(:,2:3)-1 mapping(:,4)==1 mapping(:,4)==2 mapping(:,5)==2 mapping(:,5)==3];
warning off all
stu=regstats(y, x); % regression analysis on nonstandardized variables
warning on all
y=zscore(y);x=zscore(x); % standardize the variables
warning off all
st=regstats(y, x); % regression analysis on standardized variables
warning on all
disp('Table 4')
disp([round([stu.beta st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
disp(['Number of trials in the regression analysis = ' num2str(length(y))])
disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
%% Table S2. Regression model statistics for prediction of the median response time in milliseconds (n = 36 images without eye contact). (Experiment 2)
y=nanmedian(RTo_e2,1)';
x=[2-mapping_e2(:,1) mapping_e2(:,2)-1 mapping_e2(:,4)==1 mapping_e2(:,4)==2 mapping_e2(:,5)==2 mapping_e2(:,5)==3]; % same as Experiment 1, except Background (which was constant in Experiment 2)
x([7 17 28 37],:)=[];y([7 17 28 37])=[]; % remove the eye-contact
warning off all
stu=regstats(y, x); % regression analysis on nonstandardized variables
warning on all
y=zscore(y);x=zscore(x); % standardize the variables
warning off all
st=regstats(y, x); % regression analysis on standardized variables
warning on all
disp('Table S2')
disp([round(stu.beta,1) round([st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
disp(['Number of trials in the regression analysis = ' num2str(length(y))])
disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
%% Figure 2. Braking percentage, as a function of conflict type (Vehicle Left vs. Vehicle Right), urgency level (TTC = 1.5 s: low urgency, TTC = 0.7 s: high urgency), and vehicle type (Automated GO, Automated, Traditional).
[FrameLevelM1,FrameLevelM2,FrameLevelMblinded,FrameLevelMnodriver,FrameLevelMdriver]=deal(NaN(5,3,size(X,1)));
for i=1:5 % loop over frame levels
    for i2=1:3 % loop over car types
        FrameLevelM1(i,i2,:)=nanmean(RPoP(:,mapping(:,2)==i & mapping(:,4)==i2 & mapping(:,1)==1),2); % Vehicle Right
        FrameLevelM2(i,i2,:)=nanmean(RPoP(:,mapping(:,2)==i & mapping(:,4)==i2 & mapping(:,1)==2),2); % Vehicle Left
        FrameLevelMblinded(i,i2,:) =nanmean(RPoP(:,mapping(:,2)==i & mapping(:,4)==i2 & mapping(:,5)==3),2); % Blinded
        FrameLevelMnodriver(i,i2,:)=nanmean(RPoP(:,mapping(:,2)==i & mapping(:,4)==i2 & mapping(:,5)==2),2); % No Driver
        FrameLevelMdriver(i,i2,:)  =nanmean(RPoP(:,mapping(:,2)==i & mapping(:,4)==i2 & mapping(:,5)==1),2); % Driver
    end
end

FrameLevelM1A=nanmean(FrameLevelM1,3); % 5 timings x 3 vehicle types
FrameLevelM2A=nanmean(FrameLevelM2,3);

Time=-0.8:0.2:0;
opengl hardware
figure;hold on;box on
subplot(1,2,2);
plot(Time,FrameLevelM1A(:,1),'g-s','Linewidth',3,'markersize',14);hold on
plot(Time,FrameLevelM1A(:,2),'m-o','Linewidth',3,'markersize',14);hold on
plot(Time,FrameLevelM1A(:,3),'b-^','Linewidth',3,'markersize',14);hold on
set(gca,'pos',[0.55 0.1 0.4 0.86])
title('Vehicle Right')
grid on
legend('Automated GO','Automated','Traditional','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')
subplot(1,2,1);grid on
plot(Time,FrameLevelM2A(:,1),'g-s','Linewidth',3,'markersize',14);hold on
plot(Time,FrameLevelM2A(:,2),'m-o','Linewidth',3,'markersize',14);hold on
plot(Time,FrameLevelM2A(:,3),'b-^','Linewidth',3,'markersize',14);hold on
set(gca,'pos',[0.05 0.1 0.4 0.86])
title('Vehicle Left')
grid on
legend('Automated GO','Automated','Traditional','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
%% Percentage of participants who indicated that they would brake per image (Experiment 1).
[imin, jmin]=(min(nanmean(RPoP)));[imax, jmax]=(max(nanmean(RPoP)));
disp(['Braking percentage ranged between ' num2str(imin) '% (Conflict type = ' num2str(mapping(jmin,1)) ', Frame level = ' num2str(mapping(jmin,2)) ', Background = ' num2str(mapping(jmin,3)) ', Car = '  num2str(mapping(jmin,4)) ', Window = '  num2str(mapping(jmin,5)) ')'...
    ' and ' num2str(imax) '% (Conflict type = ' num2str(mapping(jmax,1)) ', Frame level = ' num2str(mapping(jmax,2)) ', Background = ' num2str(mapping(jmax,3)) ', Car = '  num2str(mapping(jmax,4)) ', Window = '  num2str(mapping(jmax,5)) ')'])
disp(['Overall mean of the braking percentage of the 180 images = ' num2str(mean(nanmean(RPoP))) ', SD = ' num2str(std(nanmean(RPoP)))])
%% Figure S1. Experiment 1: Braking percentage, as a function of conflict type (Vehicle Left vs. Vehicle Right), urgency level (1.5 s = low urgency, 0.7 s = high urgency), and vehicle type (Automated GO, Automated, Traditional). A distinction is made between participants whose primary self-reported mode of transport was “Walking/Cycling” (n = 126) versus other participants (“Private vehicle”, “Public transportation”, “Motorcycle”, “Other”, or “I prefer not to respond”) (n = 1134).
FrameLevelM1Awalkingcycling=nanmean(FrameLevelM1(:,:,X(:,5)==4),3); % 5 timings x 3 vehicle types
FrameLevelM2Awalkingcycling=nanmean(FrameLevelM2(:,:,X(:,5)==4),3);
FrameLevelM1Anotwalkingcycling=nanmean(FrameLevelM1(:,:,X(:,5)~=4),3); % 5 timings x 3 vehicle types
FrameLevelM2Anotwalkingcycling=nanmean(FrameLevelM2(:,:,X(:,5)~=4),3);

figure;hold on;box on
subplot(2,3,1);
plot(Time,FrameLevelM2Awalkingcycling(:,1),'g:s','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM2Anotwalkingcycling(:,1),'g-s','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.03 0.57 0.28 0.39])
title('Vehicle Left, Automated GO')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')

subplot(2,3,2);
plot(Time,FrameLevelM2Awalkingcycling(:,2),'m:o','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM2Anotwalkingcycling(:,2),'m-o','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.37 0.57 0.28 0.39])
title('Vehicle Left, Automated')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')

subplot(2,3,3);
plot(Time,FrameLevelM2Awalkingcycling(:,3),'b:^','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM2Anotwalkingcycling(:,3),'b-^','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.71 0.57 0.28 0.39])
title('Vehicle Left, Traditional')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')

subplot(2,3,4);
plot(Time,FrameLevelM1Awalkingcycling(:,1),'g:s','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM1Anotwalkingcycling(:,1),'g-s','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.03 0.07 0.28 0.39])
title('Vehicle Right, Automated GO')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')

subplot(2,3,5);
plot(Time,FrameLevelM1Awalkingcycling(:,2),'m:o','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM1Anotwalkingcycling(:,2),'m-o','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.37 0.07 0.28 0.39])
title('Vehicle Right, Automated')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')

subplot(2,3,6);
plot(Time,FrameLevelM1Awalkingcycling(:,3),'b:^','Linewidth',3,'markersize',10);hold on
plot(Time,FrameLevelM1Anotwalkingcycling(:,3),'b-^','Linewidth',3,'markersize',10);hold on
set(gca,'pos',[0.71 0.07 0.28 0.39])
title('Vehicle Right, Traditional')
grid on
legend('Walking/cycling','Other','location','northwest')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xtick',Time,'xlim',[-0.8 0],'ylim',[30 85],'xticklabel',xvalues)
ylabel('Braking percentage')
xlabel('TTC (s)')
h=findobj('FontName','Helvetica'); set(h,'FontSize',14,'Fontname','Arial')
%% Figure 3. Percentage of 1260 participants who indicated that they would brake, as a function of window type (Driver, No Driver, Blinded) and vehicle type (Automated GO, Automated, Traditional) (20 responses for urgency level, visual complexity of the surroundings, and conflict type were averaged; on average participants viewed 50% of the images). The error bars represent within-subject confidence intervals, calculated for the three vehicle types separately (Morey, 2008).  
v=([squeeze(nanmean(FrameLevelMdriver,1))' squeeze(nanmean(FrameLevelMnodriver,1))' squeeze(nanmean(FrameLevelMblinded,1))']);

v_ci([1 4 7])=within_subject_ci(v(:,[1 4 7]));
v_ci([2 5 8])=within_subject_ci(v(:,[2 5 8]));
v_ci([3 6 9])=within_subject_ci(v(:,[3 6 9]));

figure;hold on
subplot(3,1,1)
barh(1,nanmean(v(:,1)),'g');hold on
barh(2,nanmean(v(:,4)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v(:,7)),'facecolor',[0.4 0.4 0.4])
title('Automated GO')
Order=[1 4 7];
for i=1:3
    O=Order(i);
    plot([nanmean(v(:,O))-v_ci(O) nanmean(v(:,O))+v_ci(O)],[i i],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.76 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})

subplot(3,1,2)
barh(1,nanmean(v(:,2)),'g');hold on
barh(2,nanmean(v(:,5)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v(:,8)),'facecolor',[0.4 0.4 0.4])
title('Automated')
Order=[2 5 8];
for i=1:3
    O=Order(i);
    plot([nanmean(v(:,O))-v_ci(O) nanmean(v(:,O))+v_ci(O)],[i i],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.42 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})

subplot(3,1,3)
barh(1,nanmean(v(:,3)),'g');hold on
barh(2,nanmean(v(:,6)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v(:,9)),'facecolor',[0.4 0.4 0.4])
title('Traditional')
Order=[3 6 9];
for i=1:3
    O=Order(i);
    plot([nanmean(v(:,O))-v_ci(O) nanmean(v(:,O))+v_ci(O)],[i i],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.08 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})
xlabel('Braking percentage')
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')

%% Figure 5. Braking percentage (n = 1086), as a function of window type (Driver, No Driver, Blinded) and vehicle type (Automated GO, Automated, Traditional) (4 responses for urgency level and conflict type were averaged). The error bars represent within-subject confidence intervals, calculated for the three vehicle types separately (Morey, 2008). 
v_e2=(RPoP_e2(:,[1:7 9:16 18:20])+RPoP_e2(:,[21:27 29:36 38:40]))/2; % Average of Vehicle Right and Vehicle Left, exclude eye contact
v_e2=(v_e2(:,1:9)+v_e2(:,10:18))/2; % Average of TTC = 1.5 and TTC = 0.7 s

v_ci_e2([1 2 3])=within_subject_ci(v(:,[1 2 3]));
v_ci_e2([4 5 6])=within_subject_ci(v(:,[4 5 6]));
v_ci_e2([7 8 9])=within_subject_ci(v(:,[7 8 9]));

figure;hold on
subplot(3,1,1)
barh(1,nanmean(v_e2(:,1)),'g');hold on
barh(2,nanmean(v_e2(:,2)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v_e2(:,3)),'facecolor',[0.4 0.4 0.4])
title('Automated GO')
for i=1:3
    plot([nanmean(v_e2(:,i))-v_ci_e2(i) nanmean(v_e2(:,i))+v_ci_e2(i)],[i i],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.76 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')

subplot(3,1,2)
barh(1,nanmean(v_e2(:,4)),'g');hold on
barh(2,nanmean(v_e2(:,5)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v_e2(:,6)),'facecolor',[0.4 0.4 0.4])
title('Automated')
for i=4:6
    plot([nanmean(v_e2(:,i))-v_ci_e2(i) nanmean(v_e2(:,i))+v_ci_e2(i)],[i-3 i-3],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.42 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')

subplot(3,1,3)
barh(1,nanmean(v_e2(:,7)),'g');hold on
barh(2,nanmean(v_e2(:,8)),'facecolor',[255 165 0]/255)
barh(3,nanmean(v_e2(:,9)),'facecolor',[0.4 0.4 0.4])
title('Traditional')
for i=7:9
    plot([nanmean(v_e2(:,i))-v_ci_e2(i) nanmean(v_e2(:,i))+v_ci_e2(i)],[i-6 i-6],'k-o','Linewidth',2,'markerfacecolor','k')
end
set(gca,'ydir','reverse','ylim',[0.3 3.7],'xlim',[38 75],'ytick',1:3,'pos',[0.06 0.08 0.92 0.20],'ticklength',[.005 .005])
set(gca,'yticklabel',{'Driver','No Driver','Blinded'})
xlabel('Braking percentage')
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')
%% Figure 6. Braking percentage (n = 1086), as a function of driver eye contact for four scenarios. The error bars represent within-subject confidence intervals (Morey, 2008). The numbers on the right represent the percentages of participants who reported ‘True’ to the statement “A driver was visible in the car” for these eight images. 
figure
V=[7 8 18 17 27 28 38 37];
eye_contact_mean=nanmean(RPoP_e2(:,V));
eye_contact_mean_CI=within_subject_ci(RPoP_e2(:,V));

b=barh(nanmean(RPoP_e2(:,V)),'r');hold on
b.FaceColor = 'flat';
b.CData(2,:) = [173 216 230]/255;
b.CData(4,:) = [173 216 230]/255;
b.CData(6,:) = [173 216 230]/255;
b.CData(8,:) = [173 216 230]/255;
for i=1:8
    plot([eye_contact_mean(i)-eye_contact_mean_CI(i) eye_contact_mean(i)+eye_contact_mean_CI(i)],[i i],'k-o','Linewidth',2,'markerfacecolor','k')
    text(80.5,i,[num2str(round(100*nanmean(Stimulus_qs_o_e2(:,V(i),4))')) '%'],'fontsize',18);
end
set(gca,'ydir','reverse','ylim',[0.3 8.7],'xlim',[45 80],'ytick',1:8,'ticklength',[.005 .005],'LooseInset',[0.01 0.01 0.05 0.01])
set(gca,'yticklabel',{'Vehicle Right, TTC = 1.5 s, No eye contact',...
                      'Vehicle Right, TTC = 1.5 s, Eye contact',...
                      'Vehicle Right, TTC = 0.7 s, No eye contact',...
                      'Vehicle Right, TTC = 0.7 s, Eye contact',...
                      'Vehicle Left, TTC = 1.5 s, No eye contact',...
                      'Vehicle Left, TTC = 1.5 s, Eye contact',...
                      'Vehicle Left, TTC = 0.7 s, No eye contact',...
                      'Vehicle Left, TTC = 0.7 s, Eye contact'});
xlabel('Braking percentage')
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')
%% Correlation
[rr,pr]=corr(nanmean(RPoP,1)',nanmedian(RTo,1)');
disp(['Correlation between median response time and Braking percentage r = ' num2str(rr) ', p = ' num2str(pr)])
%% Median response times per image (Experiment 1).
[imin, jmin]=(min(nanmedian(RTo)));[imax, jmax]=(max(nanmedian(RTo)));
disp(['Median response times per image ranged between ' num2str(imin) ' ms (Conflict type = ' num2str(mapping(jmin,1)) ', Frame level = ' num2str(mapping(jmin,2)) ', Background = ' num2str(mapping(jmin,3)) ', Car = '  num2str(mapping(jmin,4)) ', Window = '  num2str(mapping(jmin,5)) ')'...
    ' and ' num2str(imax) ' ms (Conflict type = ' num2str(mapping(jmax,1)) ', Frame level = ' num2str(mapping(jmax,2)) ', Background = ' num2str(mapping(jmax,3)) ', Car = '  num2str(mapping(jmax,4)) ', Window = '  num2str(mapping(jmax,5)) ')'])
disp(['Overall median response time of the 180 images = ' num2str(mean(nanmedian(RTo))) ', SD = ' num2str(std(nanmedian(RTo)))])
%% Figure S2. Experiment 1: Regression coefficients for prediction of the braking percentage, at the level of images (n = 180), for the five countries with the largest number of participants, and for the remainder of the countries. Error bars represent 95% confidence intervals.
% Countries for per-country analysis
countries = [{'VEN','Venezuela'}; ...
    {'USA','USA'}; ...
    {'RUS','Russia'}; ...
    {'EGY','Egypt'}; ...
    {'UKR','Ukraine'}; ...
    {'Other','Other'}];
[COUNTRY_B,COUNTRY_Bhalfrange]=deal(NaN(8,size(countries,1)));
for country=1:size(countries,1)
    disp(['***** Regression analysis for ' countries{country,1} ' *****'])
    if strcmp(countries{country,1}, 'Other')
        RPoP_filtered = RPoP(~contains(Country, countries(1:size(countries,1)-1,1)),:);
    else
        RPoP_filtered = RPoP(contains(Country, countries{country,1}),:);
    end
    
    % Regression analysis for predicting the percentage of people braking (n = 180)
    y= nanmean(RPoP_filtered,1)';
    x=[2-mapping(:,1) mapping(:,2:3)-1 mapping(:,4)==1 mapping(:,4)==2 mapping(:,5)==2 mapping(:,5)==3];
    
    warning off all
    stu=regstats(y, x); % regression analysis on nonstandardized variables
    warning on all
    [~,bint]=regress(y,[ones(size(x,1),1) x]); % compute confidence intervals
    y=zscore(y);x=zscore(x); % standardize the data
    warning off all
    st=regstats(y, x); % regression analysis on standardized variables
    warning on all
    disp([round([stu.beta st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
    disp(['Number of trials in the regression analysis = ' num2str(length(y))])
    disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
    COUNTRY_B(:,country)=stu.beta;
    COUNTRY_Bhalfrange(:,country)=range(bint')/2;
end

figure
b=barh(COUNTRY_B);
set(gca,'ydir','reverse')
fig=gcf;set(findall(fig,'-property','FontName'),'Fontsize',20)
legend(countries(1:6,2),'location','northwest','autoupdate','off')
set(gca,'ytick',1:8)
xlabel('\it{B}\rm (percentage of participants)','Fontsize',20,'Fontname','Arial')
set(gca,'yticklabel',{'Constant', 'Conflict type (0 = Vehicle Left, 1 = Vehicle Right)', 'Urgency (0 = 1.5 s, 4 = 0.7 s)', 'Surroundings (0 = Rural, 1 = Urban)', 'Vehicle (0 = Traditional, 1 = Automated GO)', ....
    'Vehicle (0 = Traditional, 1 = Automated)', 'Windows (0 = Driver, 1 = No Driver)','Windows (0 = Driver, 1 = Blinded)'},'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xlim',[-40 75])
[ctr,ydt]=deal(NaN(6,8));
for k1 = 1:6
    ctr(k1,:) = bsxfun(@plus, b(k1).XData, [b(k1).XOffset]'); % extract coordinates for plotting error bars
    ydt(k1,:) = b(k1).YData; % extract coordinates for plotting error bars
end
hold on
errorbar( ydt(:,:),ctr(:,:), COUNTRY_Bhalfrange(:,:)', 'k.','horizontal','linewidth',2)

%% Figure S4. Experiment 2: Regression coefficients for prediction of the braking percentage, at the level of images (n = 36 images without eye contact), for the five countries with the largest number of participants in Experiment 1, and for the remainder of the countries. Error bars represent 95% confidence intervals.
% Countries for per-country analysis
countries = [{'VEN','Venezuela'}; ...
    {'USA','USA'}; ...
    {'RUS','Russia'}; ...
    {'EGY','Egypt'}; ...
    {'UKR','Ukraine'}; ...
    {'Other','Other'}];
[COUNTRY_B,COUNTRY_Bhalfrange]=deal(NaN(7,size(countries,1)));
for country=1:size(countries,1)
    disp(['***** Regression analysis for ' countries{country,1} ' *****'])
    if strcmp(countries{country,1}, 'Other')
        RPoP_filtered = RPoP_e2(~contains(Country_e2, countries(1:size(countries,1)-1,1)),:);
    else
        RPoP_filtered = RPoP_e2(contains(Country_e2, countries{country,1}),:);
    end
    
    % Regression analysis for predicting the percentage of people braking (n = 40)
    y= nanmean(RPoP_filtered,1)';
    x=[2-mapping_e2(:,1) mapping_e2(:,2)-1 mapping_e2(:,4)==1 mapping_e2(:,4)==2 mapping_e2(:,5)==2 mapping_e2(:,5)==3]; % same as Experiment 1, except Background (which was constant in Experiment 2)
    x([7 17 28 37],:)=[];y([7 17 28 37])=[]; % remove the eye-contact
    
    warning off all
    stu=regstats(y, x); % regression analysis on nonstandardized variables
    warning on all
    [~,bint]=regress(y,[ones(size(x,1),1) x]); % compute confidence intervals
    y=zscore(y);x=zscore(x); % standardize the data
    warning off all
    st=regstats(y, x); % regression analysis on standardized variables
    warning on all
    disp([round([stu.beta st.beta st.tstat.t ],3),round(1000*st.tstat.pval(1:end))/1000])
    disp(['Number of trials in the regression analysis = ' num2str(length(y))])
    disp([st.fstat.dfr st.fstat.dfe st.fstat.f st.fstat.pval corr(st.yhat,y) st.rsquare])
    COUNTRY_B(:,country)=stu.beta;
    COUNTRY_Bhalfrange(:,country)=range(bint')/2;
end

figure
b=barh(COUNTRY_B);
set(gca,'ydir','reverse')
fig=gcf;set(findall(fig,'-property','FontName'),'Fontsize',20)
legend(countries(1:6,2),'location','northwest','autoupdate','off')
set(gca,'ytick',1:7)
xlabel('\it{B}\rm (percentage of participants)','Fontsize',20,'Fontname','Arial')
set(gca,'yticklabel',{'Constant', 'Conflict type (0 = Vehicle Left, 1 = Vehicle Right)', 'Urgency (0 = 1.5 s, 4 = 0.7 s)', 'Vehicle (0 = Traditional, 1 = Automated GO)', ....
    'Vehicle (0 = Traditional, 1 = Automated)', 'Windows (0 = Driver, 1 = No Driver)','Windows (0 = Driver, 1 = Blinded)'},'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01],'xlim',[-50 75])
[ctr,ydt]=deal(NaN(6,7));
for k1 = 1:6
    ctr(k1,:) = bsxfun(@plus, b(k1).XData, [b(k1).XOffset]'); % extract coordinates for plotting error bars
    ydt(k1,:) = b(k1).YData; % extract coordinates for plotting error bars
end
hold on
errorbar( ydt(:,:),ctr(:,:), COUNTRY_Bhalfrange(:,:)', 'k.','horizontal','linewidth',2)
%% Table S3. Overview of the 40 images and results (braking percentage, median response time, and percentage of participants indicating ‘true’ for four image features). (Experiment 2)
disp('Table S3')
disp([nanmean(RPoP_e2)' nanmedian(RTo_e2)' nanmean(Stimulus_qs_o_e2(:,:,1))' nanmean(Stimulus_qs_o_e2(:,:,2))' nanmean(Stimulus_qs_o_e2(:,:,3))' nanmean(Stimulus_qs_o_e2(:,:,4))']) %#ok<*NANMEAN>
disp('Number of participants who participated in Experiment 1 and 2')
disp(length(intersect(X(:,end),X_e2(:,end))))
%% Figure S3. Median response times versus trial number for Experiment 1 and Experiment 2. The spikes in the graph for Experiment 1 correspond to trials that directly followed the breaks.
clear h
figure;hold on
h(1)=plot(1:30,nanmedian(RT(:,1:30)),'k-o','Linewidth',2);
plot(31:60,nanmedian(RT(:,31:60)),'k-o','Linewidth',2)
plot(61:90,nanmedian(RT(:,61:90)),'k-o','Linewidth',2)
h(2)=plot(1:40,nanmedian(RT_e2),'r:o','Linewidth',2);
grid on
legend(h,'Experiment 1','Experiment 2')
set(gca,'xtick',[1 10:10:90],'xlim',[.5 90.5])
grid on;box on
xlabel('Trial number')
ylabel('Median response time (ms)')
fig=gcf;set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',18)
set(gca, 'LooseInset', [0.01 0.01 0.01 0.01]);
%%
% CI is half of the confidence interval; so it should be plotted from mean-CI to mean+CI 
% Morey, R. D. (2008). Confidence intervals from normalized data: A correction to Cousineau (2005). Reason, 4, 61-64.
function CI = within_subject_ci(X)
    X=X-repmat(nanmean(X,2),1,size(X,2)); % subtract participant mean
    [~,~,ci]=ttest(X); % calculate confidence interval assuming a normal distribution
    CI=diff(ci)/2*sqrt(size(X,2)/(size(X,2)-1)); % Correction factor as described in Morey (2008)
end
